CREATE OR REPLACE FUNCTION DROPCOLUMN()
RETURNS VOID AS
$BODY$
BEGIN
    IF EXISTS (SELECT 1 
                FROM information_schema.columns     
                WHERE table_name = 'fp_func' 
                  and column_name='flag_desab_autenticacao_2f'
	) THEN
        ALTER TABLE fp_func DROP flag_desab_autenticacao_2f;
		RAISE NOTICE 'Coluna "flag_desab_autenticacao_2f" removida com sucesso!';   
    ELSE
		RAISE NOTICE 'Coluna flag_desab_autenticacao_2f na tabela fp_func não existe!' ;
    END IF; 
    
END; 

$BODY$
LANGUAGE PLPGSQL VOLATILE  COST 100;
ALTER FUNCTION DROPCOLUMN()  OWNER TO POSTGRES;
SELECT DROPCOLUMN();
DROP FUNCTION DROPCOLUMN();


CREATE OR REPLACE FUNCTION add_column_flag_habilita_uso_2fa_to_glb_usu()
RETURNS VOID AS
$BODY$
BEGIN
    IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS
                   WHERE TABLE_NAME ILIKE 'glb_usu'
                   AND COLUMN_NAME ILIKE 'flag_habilita_uso_2fa') THEN
        ALTER TABLE glb_usu
        ADD flag_habilita_uso_2fa INT; -- Altere o tipo de dado conforme necessário
        RAISE NOTICE 'Coluna flag_habilita_uso_2fa adicionada à tabela glb_usu!';
    END IF;
END;
$BODY$
LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION add_column_flag_habilita_uso_2fa_to_glb_usu() OWNER TO postgres;
SELECT add_column_flag_habilita_uso_2fa_to_glb_usu();
DROP FUNCTION add_column_flag_habilita_uso_2fa_to_glb_usu();